// priority: 50

/**
 * @param {object} e 
 * @param {Array<object>} 
 * @param {string}
 * @param {object} [配件]
 * @param {Array<object>} [附魔]
 * @param {object} [额外NBT]
 * @param {string} [配方ID]
 */
let 枪械配方 = (e, 材料, 结果ID, 配件, 附魔, 额外NBT, 配方ID) => {
  let 最终结果 = {
    "type": "gun",
    "id": 结果ID
  };

  let nbtData = {};

  if (配件) {
    最终结果.attachments = 配件;
  }

  if (附魔 && 附魔.length > 0) {
    nbtData.Enchantments = 附魔;
  }

  if (额外NBT && typeof 额外NBT === "object") {
    for (let key in 额外NBT) {
      if (Object.hasOwnProperty.call(额外NBT, key)) {
        nbtData[key] = 额外NBT[key];
      }
    }
  }
  
  if (Object.keys(nbtData).length > 0) {
    最终结果.nbt = nbtData;
  }


  let 配方数据 = {
    "type": "tacz:gun_smith_table_crafting",
    "materials": 材料,
    "result": 最终结果
  };

  let recipe = e.custom(配方数据);
  if (配方ID) {
    recipe.id(配方ID);
  }
}

ServerEvents.recipes(e => {

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 14 }],
    "tacz:m870",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_m870" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:cz75" } }, count: 1 },
      { item: { item: "kubejs:d_material" }, count: 4 },
    ],
    "tacz:m1911",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_m1911"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 10 }],
    "tacz:g36k",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_g36k"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 4 }],
    "tacz:b93r",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_b93r"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 14 }],
    "tacz:mk14",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_mk14"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:hk_mp5a5" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 7 }
    ],
    "tacz:p90",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_p90"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 3 }],
    "tacz:p320",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_p320"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 10 }],
    "tacz:qbz_95",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_qbz_95"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:m320" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 14 }
    ],
    "tacz:rpg7",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_rpg7"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 15 }],
    "tacz:rpk",
    { stock: "tacz:oem_stock_heavy" },
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_rpk"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:scar_l" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 11 }
    ],
    "tacz:scar_h",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_scar_h"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 11 }],
    "tacz:scar_l",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_scar_l"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 6 }],
    "tacz:ump45",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_ump45"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "lradd:nailgun" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 6 }
    ],
    "tacz:uzi",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_uzi"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 8 }],
    "tacz:type_81",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_type_81"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 12 }],
    "tacz:sks_tactical",
    { stock: "tacz:oem_stock_tactical" },
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_sks_tactical"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:db_long" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 13 }
    ],
    "tacz:aa12",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_aa12"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 17 }],
    "tacz:springfield1873",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_springfield1873"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 18 }],
    "tacz:ai_awp",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_ai_awp"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 12 }],
    "tacz:ak47",
    { stock: "tacz:oem_stock_tactical" },
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_ak47"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:m4a1" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 10 }
    ],
    "tacz:aug",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_aug"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 4 }],
    "tacz:cz75",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_cz75"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:uzi" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 6 }
    ],
    "tacz:vector45",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_vector45"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 13 }],
    "tacz:db_long",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_db_long"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 13 }],
    "tacz:db_short",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_db_short"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:p320" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 3 }
    ],
    "tacz:deagle",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_deagle"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:deagle_golden" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 3 }
    ],
    "tacz:timeless50",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "tacz:gun_smith_table/gun_tacz_timeless50"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:deagle" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 3 }
    ],
    "tacz:deagle_golden",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_deagle_golden"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 4 }],
    "tacz:glock_17",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_glock_17"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 7 }],
    "tacz:hk_mp5a5",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_hk_mp5a5"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 12 }],
    "tacz:hk_g3",
    { stock: "tacz:oem_stock_tactical" },
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_hk_g3"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 9 }],
    "tacz:hk416d",
    { stock: "tacz:oem_stock_tactical" },
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_hk416d"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 10 }],
    "tacz:m4a1",
    { stock: "tacz:oem_stock_tactical" },
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_m4a1"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 9 }],
    "tacz:m16a1",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_m16a1"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 9 }],
    "tacz:m16a4",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_m16a4"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:springfield1873" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 17 }
    ],
    "tacz:m95",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_m95"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "eos:wa2000" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 16 }
    ],
    "tacz:m107",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_m107"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 21 }],
    "tacz:m249",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_m249"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 20 }],
    "tacz:minigun",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_minigun"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 10 }],
    "tacz:m320",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_m320"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:d_material" }, count: 16 }],
    "tacz:m700",
    null,
    null,
    null,
    "tacz:gun_smith_table/gun_tacz_m700"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_h12" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 15 }
    ],
    "emxarms:emx_draftsman",
    null,
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_draftsman" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_draftsman" } }, count: 1 },
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxarms:sight_emx_char2" } }, count: 1 },
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxarms:grip_emx_if" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 15 }
    ],
    "emxarms:emx_draftsman_ev",
    { scope: "emxarms:sight_emx_char2_ev", grip: "emxarms:grip_emx_if_ev", extended_mag: "emxarms:emx_lightweight_mag_2" },
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_draftsman_ev"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_draftsman_ev" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 15 }
    ],
    "emxarms:emx_draftsman_ev1",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_draftsman_ev1"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:aa12" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 13 }
    ],
    "emxarms:emx_enforcer",
    { scope: "emxarms:sight_emx_laterano" },
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_enforcer"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_bal" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 6 }
    ],
    "emxarms:emx_expel32_lb",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_expel32_lb"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:ump45" } }, count: 1 },
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxarms:sight_emx_integer" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 6 }
    ],
    "emxarms:emx_expel32se", // 注意: 此处原始数据result中未定义attachments，但ID为emxarms:emx_expel32se
    null, // 根据数据，此处无配件对象
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_expel32se"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_expel32" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 6 }
    ],
    "emxarms:emx_expel32se_ba",
    null,
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_expel32se_ba"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_umx32" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 6 }
    ],
    "emxarms:emx_expel32",
    { scope: "emxarms:sight_emx_aps" },
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_expel32" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:timeless50" } }, count: 1 },
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxarms:grip_emx_double" } }, count: 1 },
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxarms:bayonet_emx_glowsword" } }, count: 1 },
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxarms:sight_emx_demo2" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 3 }
    ],
    "emxarms:emx_kund50ex_al",
    { scope: "emxarms:sight_emx_laterano_yh", muzzle: "emxarms:bayonet_emx_skyhunter_yh", grip: "emxarms:grip_emx_double_yh" },
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_kund50ex_yh"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_pulse" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 4 }
    ],
    "emxarms:emx_mac50",
    null,
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_mac50"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:rpk" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 18 },
      { item: { item: "kubejs:c_material" }, count: 15 }
    ],
    "emxarms:emx_mg57",
    null,
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_mg57"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_mg57" } }, count: 1 },
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxarms:grip_emx_double" } }, count: 1 },
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxarms:grip_emx_synchronized0" } }, count: 1 },
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxarms:sight_emx_return" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 18 }
    ],
    "emxarms:emx_mg57_yh",
    { scope: "emxarms:sight_emx_return_yh", extended_mag: "emxarms:emx_heavyweight_mag_3", grip: "emxarms:grip_emx_synchronized0_yh" },
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_mg57_yh"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:ai_awp" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 18 }
    ],
    "emxarms:emx_mk88",
    null,
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_mk88"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_mk951r" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 10 }
    ],
    "emxarms:emx_mk951l",
    null,
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_mk951l"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_mk951r_ba" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 10 }
    ],
    "emxarms:emx_mk951l_ba",
    { scope: "emxarms:sight_emx_aw_ba" },
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_mk951l_ba"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:qbz_95" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 10 }
    ],
    "emxarms:emx_mk951r",
    null,
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_mk951r"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_mk951l" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 10 }
    ],
    "emxarms:emx_mk951r_ba",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_mk951r_ba"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:m249" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 21 }
    ],
    "emxarms:emx_mk951lmg",
    null,
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_mk951lmg"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:m95" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 17 }
    ],
    "emxarms:emx_pmg90",
    { scope: "emxarms:sight_emx_array", extended_mag: "emxarms:emx_lightweight_mag_2" },
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_pmg90"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:b93r" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 4 }
    ],
    "emxarms:emx_pulse",
    null,
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_pulse"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_pulse" } }, count: 1 },
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxarms:grip_emx_double" } }, count: 1 },
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxarms:bayonet_emx_glowsword" } }, count: 1 },
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxarms:sight_emx_demo2" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 8 }
    ],
    "emxarms:emx_pulse_al",
    { scope: "emxarms:sight_emx_laterano_rsi", muzzle: "emxarms:bayonet_emx_skyhunter2", grip: "emxarms:grip_emx_double_rsi" },
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_pulse_al"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_pulse" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 5 }
    ],
    "emxarms:emx_pulse_dl1",
    null,
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_pulse_dl1"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxcust:rd704_murusama" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 9 }
    ],
    "emxarms:emx_rivet",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_rivet"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_rivet" } }, count: 1 },
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxarms:bayonet_emx_skyhunter" } }, count: 1 },
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxarms:sight_emx_return" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 9 }
    ],
    "emxarms:emx_rivet_gw",
    { scope: "emxarms:sight_emx_anonymous_gw", muzzle: "emxarms:bayonet_emx_skyhunter_gw" },
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_rivet_gw"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:db_short" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 13 }
    ],
    "emxarms:emx_scgraves",
    null,
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_scgraves"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_sf10" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 21 }
    ],
    "emxarms:emx_sf7b",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_sf7b"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxarms:bayonet_emx_skyhunter" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 4 }
    ],
    "emxarms:emx_tknife",
    { muzzle: "emxarms:bayonet_emx_skyhunter" },
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_tknife"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_expel32se" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 6 }
    ],
    "emxarms:emx_umx32",
    null,
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_umx32"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxcust:p90_tris92" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 7 }
    ],
    "emxarms:emx_umx32_koei",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_umx32_koei"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:ak47" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 12 }
    ],
    "emxarms:emx_umx57",
    null,
    null,
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_umx57"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_karma45_d" } }, count: 1 },
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxarms:sight_emx_char2" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 12 }
    ],
    "emxarms:emx_umx57h",
    { scope: "emxarms:sight_emx_aw_h", grip: "emxarms:grip_emx_double_h" },
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxarms_:gun_smith_table/gun_emxarms_emx_umx57h"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:p90" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 7 }
    ],
    "emxcust:p90_tris92",
    null,
    null,
    null,
    "emxcust_:gun_smith_table/gun_emxcust_p90_tris92"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_icr" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 9 }
    ],
    "emxcust:rd704_murusama",
    null,
    null,
    null,
    "emxcust_:gun_smith_table/gun_emxcust_rd704_murusama"
  );

  枪械配方(
    e,
    [{ item: { item: "kubejs:c_material" }, count: 14 }],
    "emxmors:emx_1887",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_1887"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "setsentinel:set_pur" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 4 }
    ],
    "emxmors:emx_ace",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_ace"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:aug" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 10 }
    ],
    "emxmors:emx_basb",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_basb"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "lradd:mag7" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 15 }
    ],
    "emxmors:emx_h12",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_h12"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:glock_17" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 4 }
    ],
    "emxmors:emx_hawkmoon",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_hawkmoon"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_1887" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 14 }
    ],
    "emxmors:emx_heritage",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_heritage"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:vector45" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 6 }
    ],
    "emxmors:emx_bal",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_bal"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:minigun" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 20 }
    ],
    "emxmors:emx_hk21",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_hk21"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "trisdyna:omerta" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 11 }
    ],
    "emxmors:emx_hvk30",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_hvk30"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:hk416d" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 9 }
    ],
    "emxmors:emx_icr",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_icr"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_umx57" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 12 }
    ],
    "emxmors:emx_karma45",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_karma45"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_karma45" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 12 }
    ],
    "emxmors:emx_karma45_d",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_karma45_d"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:scar_h" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 11 }
    ],
    "emxmors:emx_kv1",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_kv1"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_kv1" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 11 }
    ],
    "emxmors:emx_kv2",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_kv2"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:m700" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 16 }
    ],
    "emxmors:emx_locus",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_locus"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_locus" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 16 }
    ],
    "emxmors:emx_locusmk1",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_locusmk1"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:m107" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 16 }
    ],
    "emxmors:emx_longbow",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_longbow"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "pgp:b101" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 8 }
    ],
    "emxmors:emx_lwt",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_lwt"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_mors" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 17 }
    ],
    "emxmors:emx_morsmk1",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_morsmk1"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_pmg90" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 17 }
    ],
    "emxmors:emx_mors",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_mors"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "eos:chasing_light" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 10 }
    ],
    "emxmors:emx_nraw4_l",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_nraw4_l"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "setsentinel:set_svg100" } }, count: 1 },
      { item: { type: "forge:partial_nbt", item: "tacz:attachment", nbt: { AttachmentId: "emxmors:sight_emx_cpuarray" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 16 }
    ],
    "emxmors:emx_royalty",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_royalty"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_xenophage" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 21 }
    ],
    "emxmors:emx_sf10",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_sf10"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "eos:clover_cross" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 17 }
    ],
    "emxmors:emx_succession",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_succession"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_mac50" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 4 }
    ],
    "emxmors:emx_tlw",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_tlw"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_nraw4_l" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 10 }
    ],
    "emxmors:emx_volk",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_volk"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_mk951lmg" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 21 }
    ],
    "emxmors:emx_xenophage",
    null,
    null,
    null,
    "emxmors_:gun_smith_table/gun_emxmors_emx_xenophage"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:g36k" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 10 }
    ],
    "eos:chasing_light",
    { scope: "eos:scope_chasing_light", grip: "eos:grip_chasing_light", muzzle: "eos:muzzle_chasing_light" },
    null,
    null,
    "eos_:gun_smith_table/gun_eos_chasing_light" 
  );

  枪械配方(
    e,
    [
      { item: { item: "kubejs:d_material" }, count: 17 }
    ],
    "eos:clover_cross",
    null,
    null,
    null,
    "eos_:gun_smith_table/gun_eos_clover_cross" 
  );

  枪械配方(
    e,
    [
      { item: { item: "kubejs:b_material" }, count: 12 }
    ],
    "eos:elp_13_t3",
    null,
    null,
    null,
    "eos_:gun_smith_table/gun_eos_elp_13_t3" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "eos:elp_13_t3" } }, count: 2 },
      { item: { item: "kubejs:b_material" }, count: 2 }
    ],
    "eos:elp_13_t3x2",
    null,
    null,
    null,
    "eos_:gun_smith_table/gun_eos_elp_13_t3x2" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "trisdyna:ch104" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 10 }
    ],
    "eos:elp_34_t3",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "eos_:gun_smith_table/gun_eos_elp_34_t3" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_bal" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 7 }
    ],
    "eos:elp_34c_t3",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "eos_:gun_smith_table/gun_eos_elp_34c_t3" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_succession" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 17 }
    ],
    "eos:elp_45_t3",
    { scope: "eos:scope_eos_ts17" },
    null,
    null,
    "eos_:gun_smith_table/gun_eos_elp_45_t3" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_longbow" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 16 }
    ],
    "eos:elp_52_t3",
    { scope: "eos:scope_elp_52_t3_default" },
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "eos_:gun_smith_table/gun_eos_elp_52_t3" 
  );

    枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "trisdyna:fpc211" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 13 }
    ],
    "eos:elp_72_t3",
    { muzzle: "eos:bayonet_katana" },
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "eos_:gun_smith_table/gun_eos_elp_72_t3" 
  );

  枪械配方(
    e,
    [
      { item: { item: "kubejs:d_material" }, count: 16 }
    ],
    "eos:wa2000",
    { scope: "eos:scope_schmidt_bender_10x56mm", grip: "eos:wa2000_grip" },
    null,
    null,
    "eos_:gun_smith_table/gun_eos_wa2000" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_enforcer" } }, count: 1 },
      { item: { item: "touhou_little_maid:garage_kit" }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 13 }
    ],
    "fire_fox:fire_fox",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "fire_fox:gun_smith_table/gun_fire_fox_fire_fox" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_mk88" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 18 }
    ],
    "pgp:atzkav",
    null,
    null,
    null,
    "pgp_:gun_smith_table/gun_pgp_atzkav" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "lradd:nitro_505" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 8 }
    ],
    "pgp:b101",
    null,
    null,
    null,
    "pgp_:gun_smith_table/gun_pgp_b101" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_ace" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 4 }
    ],
    "pgp:cfdz",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "pgp_:gun_smith_table/gun_pgp_cfdz" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "setsentinel:set_rw1" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 4 }
    ],
    "pgp:n3516",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "pgp_:gun_smith_table/gun_pgp_n3516" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "pgp:nak954" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 11 }
    ],
    "pgp:nah",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "pgp_:gun_smith_table/gun_pgp_nah" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_hvk30" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 11 }
    ],
    "pgp:nak954",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "pgp_:gun_smith_table/gun_pgp_nak954" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "trisdyna:emx_cf107" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 20 }
    ],
    "pgp:solar0",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    { "ammo_count": 7000 },
    "pgp_:gun_smith_table/gun_pgp_solar0" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "eos:elp_45_t3" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 17 }
    ],
    "pgp:z761",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "pgp_:gun_smith_table/gun_pgp_z761" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "pgp:z761" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 17 }
    ],
    "pgp:z750",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "pgp_:gun_smith_table/gun_pgp_z750" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_umx32_koei" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 7 }
    ],
    "setsentinel:set_apc9",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "setsentinel_:gun_smith_table/gun_setsentinel_set_apc9" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_volk" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 10 }
    ],
    "setsentinel:set_acr",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "setsentinel_:gun_smith_table/gun_setsentinel_set_acr" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "eos:elp_72_t3" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 13 }
    ],
    "setsentinel:set_freedom",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "setsentinel_:gun_smith_table/gun_setsentinel_set_freedom" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "eos:elp_52_t3" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 16 }
    ],
    "setsentinel:set_izanagis",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "setsentinel_:gun_smith_table/gun_setsentinel_set_izanagis" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_kv2" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 11 }
    ],
    "setsentinel:set_justice",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "setsentinel_:gun_smith_table/gun_setsentinel_set_justice" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_tlw" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 4 }
    ],
    "setsentinel:set_annihilator",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "setsentinel_:gun_smith_table/gun_setsentinel_set_annihilator" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_hawkmoon" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 4 }
    ],
    "setsentinel:set_pur",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "setsentinel_:gun_smith_table/gun_setsentinel_set_pur" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "trisdyna:fl3e" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 4 }
    ],
    "setsentinel:set_rw1",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "setsentinel_:gun_smith_table/gun_setsentinel_set_rw1" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_locusmk1" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 16 }
    ],
    "setsentinel:set_svg100",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "setsentinel_:gun_smith_table/gun_setsentinel_set_svg100" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_basb"} }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 10 }
    ],
    "trisdyna:ch104",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "trisdyna_:gun_smith_table/gun_trisdyna_ch104" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxmors:emx_hk21" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 20 }
    ],
    "trisdyna:emx_cf007",
    null,
    null,
    null,
    "trisdyna_:gun_smith_table/gun_trisdyna_emx_cf007" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "trisdyna:emx_cf007" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 20 }
    ],
    "trisdyna:emx_cf107",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "trisdyna_:gun_smith_table/gun_trisdyna_emx_cf107" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:m1911" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 4 }
    ],
    "trisdyna:fl3e",
    null,
    null,
    null,
    "trisdyna_:gun_smith_table/gun_trisdyna_fl3e" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "emxarms:emx_scgraves" } }, count: 1 },
      { item: { item: "kubejs:b_material" }, count: 13 }
    ],
    "trisdyna:fpc211",
    null,
    null,
    null,
    "trisdyna_:gun_smith_table/gun_trisdyna_fpc211" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "fire_fox:fire_fox" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 13 }
    ],
    "trisdyna:iras",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "trisdyna_:gun_smith_table/gun_trisdyna_iras" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "trisdyna:rc" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 14 },
      { item: { item: "irons_spellbooks:energized_core" }, count: 5 },
      { item: { item: "aquamirae:rune_of_the_storm" }, count: 1 }
    ],
    "trisdyna:r117_weedy",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    { "ammo_count": 5000 },
    "trisdyna_:gun_smith_table/gun_trisdyna_r117_weedy" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "lradd:m202" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 14 }
    ],
    "trisdyna:rc",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "trisdyna_:gun_smith_table/gun_trisdyna_rc" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "pgp:atzkav" } }, count: 1 },
      { item: { item: "kubejs:a_material" }, count: 18 }
    ],
    "trisdyna:tris_sf7e",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "trisdyna_:gun_smith_table/gun_trisdyna_tris_sf7e" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "trisdyna:tris_sf7e" } }, count: 1 },
      { item: { item: "kubejs:s_material" }, count: 18 }
    ],
    "trisdyna:s10dmd",
    null,
    [{ id: "l2complements:ender_reach", lvl: 1 }],
    null,
    "trisdyna_:gun_smith_table/gun_emxarms_s10dmd" 
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "lradd:qbz191_em" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 11 }
    ],
    "trisdyna:omerta",
    null,
    null,
    null,
    "trisdyna_:gun_smith_table/gun_trisdyna_omerta" 
  );

  枪械配方(
    e,
    [
      { item: { item: "kubejs:d_material" }, count: 11 }
    ],
    "lradd:qbz191_em",
    null,
    null,
    null,
    "lradd_:gun_smith_table/gun_lradd_qbz_191"
  );

  枪械配方(
    e,
    [
      { item: { item: "kubejs:d_material" }, count: 6 }
    ],
    "lradd:nailgun",
    null,
    null,
    null,
    "lradd_:gun_smith_table/gun_lradd_nailgun" 
  );

  枪械配方(
    e,
    [
      { item: { item: "kubejs:d_material" }, count: 15 }
    ],
    "lradd:mag7",
    null,
    null,
    null,
    "lradd_:gun_smith_table/gun_lradd_mag_7"
  );

  枪械配方(
    e,
    [
      { item: { type: "forge:partial_nbt", item: "tacz:modern_kinetic_gun", nbt: { GunId: "tacz:rpg7" } }, count: 1 },
      { item: { item: "kubejs:c_material" }, count: 14 }
    ],
    "lradd:m202",
    null,
    null,
    null,
    "lradd_:gun_smith_table/gun_lradd_m202" 
  );

  枪械配方(
    e,
    [
      { item: { item: "kubejs:d_material" }, count: 8 }
    ],
    "lradd:nitro_505",
    null,
    null,
    null,
    "lradd_:gun_smith_table/gun_lradd_nitro_505" 
  );
    
});